% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr}
\alias{rba_enrichr}
\title{A One-step Wrapper for Gene-list Enrichment Using Enrichr}
\usage{
rba_enrichr(
  gene_list,
  description = NULL,
  gene_set_library = "all",
  regex_library_name = FALSE,
  organism = "human",
  background_genes = NULL,
  progress_bar = TRUE,
  ...
)
}
\arguments{
\item{gene_list}{A character vector with Entrez gene symbols of test genes.}

\item{description}{(optional) A description to be associated with your
uploaded gene-set to Enrichr servers.}

\item{gene_set_library}{One of the:
\enumerate{
\item "all" to select all of the available Enrichr gene-set libraries.
\item A gene-set library name. You can retrieve the available options
for a given species using \code{\link{rba_enrichr_libs}}.
\item If regex_library_name = TRUE, A partially-matching name a regex
pattern that correspond to one or more of Enrichr library names.
}}

\item{regex_library_name}{logical: (default = FALSE) if TRUE the supplied
gene_set_library will be considered as a regex pattern.
If FALSE, gene_set_library will be considered as an exact match.}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{background_genes}{A character vector of Entrez gene symbols of the
background genes.}

\item{progress_bar}{logical: (default = TRUE) if multiple Enrichr libraries
are selected, should a progress bar be displayed?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing data frames of the enrichment results of your
  supplied gene-list against the selected Enrichr libraries.
}
\description{
This function provides a convenient one-step wrapper for performing
  enrichment analysis on a given gene list using Enrichr. It simplifies the
  process by internally calling the necessary functions in the correct order.
  See the details section for more information.
}
\details{
This function will call other rba_enrichr_*** functions with the following
  order:
  \enumerate{
  \item (If necessary) Call \code{\link{rba_enrichr_libs}} to obtain a list
    of available libraries in Enrichr for the given organism.
  \item Call \code{\link{rba_enrichr_add_list}} to upload your gene-list
    and obtain a 'user list ID'.
  \item (If necessary) Call \code{\link{rba_enrichr_add_background}} to
    upload your background gene-list and obtain a 'background list ID'.
  \item Call \code{\link{rba_enrichr_enrich}} to perform enrichment analysis
    on the gene-list against one or multiple Enrichr libraries
  }
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/datasetStatistics"
 \cr "POST https://maayanlab.cloud/Enrichr/addList"
 \cr "POST https://maayanlab.cloud/speedrichr/api/addList"
 \cr "POST https://maayanlab.cloud/speedrichr/api/addbackground"
 \cr "GET https://maayanlab.cloud/Enrichr/enrich"
 \cr "POST https://maayanlab.cloud/speedrichr/api/backgroundenrich"
}

\examples{
\dontrun{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"))
}
\donttest{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"),
    gene_set_library = "GO_Molecular_Function_2025",
    regex_library_name = FALSE)
}
\donttest{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"),
    gene_set_library = "go",
    regex_library_name = TRUE)
}

}
\references{
\itemize{
  \item Chen, E.Y., Tan, C.M., Kou, Y. et al. Enrichr: interactive and
  collaborative HTML5 gene list enrichment analysis tool. Bioinformatics
  14, 128 (2013). https://doi.org/10.1186/1471-2105-14-128
  \item Maxim V. Kuleshov, Matthew R. Jones, Andrew D. Rouillard, Nicolas
  F. Fernandez, Qiaonan Duan, Zichen Wang, Simon Koplev, Sherry L. Jenkins,
  Kathleen M. Jagodnik, Alexander Lachmann, Michael G. McDermott,
  Caroline D. Monteiro, Gregory W. Gundersen, Avi Ma’ayan, Enrichr: a
  comprehensive gene set enrichment analysis web server 2016 update,
  Nucleic Acids Research, Volume 44, Issue W1, 8 July 2016, Pages W90–W97,
  https://doi.org/10.1093/nar/gkw377
  \item Xie, Z., Bailey, A., Kuleshov, M. V., Clarke, D. J. B.,
  Evangelista, J. E., Jenkins, S. L., Lachmann, A., Wojciechowicz, M. L.,
  Kropiwnicki, E., Jagodnik, K. M., Jeon, M., & Ma’ayan, A. (2021). Gene
  set knowledge discovery with Enrichr. Current Protocols, 1, e90.
  doi: 10.1002/cpz1.90
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  \item \href{https://maayanlab.cloud/Enrichr/help#terms}{Citations note
  on Enrichr website}
  }
}
\seealso{
Other "Enrichr": 
\code{\link{rba_enrichr_add_background}()},
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()}

Other "Enrichment/Over-representation": 
\code{\link{rba_mieaa_enrich}()},
\code{\link{rba_panther_enrich}()},
\code{\link{rba_reactome_analysis}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_enrichment_image}()}
}
\concept{"Enrichment/Over-representation"}
\concept{"Enrichr"}
