% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{base64-utils}
\alias{base64-utils}
\alias{base64_urlencode}
\alias{base64_encode}
\alias{base64_urldecode}
\alias{base64_decode}
\alias{base64_plot}
\title{Convert from and to 'base64' string}
\usage{
base64_urlencode(x)

base64_encode(x)

base64_urldecode(x)

base64_decode(x)

base64_plot(
  expr,
  width = 480,
  height = 480,
  ...,
  quoted = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{x}{for encoders, this is an R raw or character vectors; for decoders
this is 'base64' encoded strings}

\item{expr}{expression for plot, will saved to a \code{\link[grDevices]{png}}
and converted to 'base64' string}

\item{width, height}{image size in pixels}

\item{...}{passed to \code{\link[grDevices]{png}}}

\item{quoted, envir}{non-standard evaluation settings}
}
\value{
\code{base64_encode}, \code{base64_plot} returns 'base64' string in
raw format; \code{base64_urlencode} returns 'base64' string url-safe format;
\code{base64_urldecode} returns the original string; \code{base64_decode}
returns original raw vectors.
}
\description{
Encode or decode 'base64' raw or url-safe string
}
\examples{

# ---- For direct base64URI ------------------------------------


file_raw <- as.raw(1:255)

# raw base64
base64_raw <- base64_encode(file_raw)
base64_raw

as.integer(base64_decode(base64_raw))

# ---- For URL-save base64 ------------------------------------
# Can be used in URL
base64_url <- base64_urlencode(
  paste(c(letters, LETTERS, 0:9),
  collapse = ""))
base64_url

base64_urldecode(base64_url)

# ---- Convert R plots to base64 --------------------------------
img <- base64_plot({
  plot(1:10)
}, width = 320, height = 320)

# summary
print(img)

# get base64 content
img_base64 <- format(img, type = "content")

# save to png
tmppng <- tempfile(fileext = ".png")
writeBin(base64_decode(img_base64), con = tmppng)

# cleanup
unlink(tmppng)

# Format as svg
format(img, type = "html_svg")

}
