% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class100-base_repository.R
\name{prepare_subject_bare}
\alias{prepare_subject_bare}
\alias{prepare_subject_bare0}
\title{'RAVE' repository: basic}
\usage{
prepare_subject_bare(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  ...,
  auto_exclude = FALSE,
  quiet = TRUE,
  repository_id = NULL
)

prepare_subject_bare0(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  ...,
  auto_exclude = FALSE,
  quiet = TRUE,
  repository_id = NULL
)
}
\arguments{
\item{subject}{'RAVE' subject}

\item{electrodes}{string or integers indicating electrodes to load}

\item{reference_name}{name of the reference table}

\item{...}{passed to \code{\link{RAVESubjectBaseRepository}} constructor}

\item{auto_exclude}{whether to automatically discard bad channels}

\item{quiet}{see field \code{quiet}}

\item{repository_id}{see field \code{repository_id}}
}
\value{
A \code{\link{RAVESubjectBaseRepository}} instance
}
\description{
'RAVE' repository: basic
}
\examples{

if( has_rave_subject("demo/DemoSubject") ) {


repository <- prepare_subject_bare0("demo/DemoSubject",
                                    electrodes = 14:16,
                                    reference_name = "default")

print(repository)

repository$subject
repository$subject$raw_sample_rates

repository$electrode_table

repository$reference_table

electrodes <- repository$electrode_instances

# Channel 14
e <- electrodes$e_14

# referenced voltage
voltage <- e$load_data_with_blocks("008", "voltage")

ravetools::diagnose_channel(voltage, srate = 2000)


}

}
