% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{timestep_instruments}
\alias{timestep_instruments}
\title{Take an implicit timestep for all the given instruments}
\usage{
timestep_instruments(
  z,
  prev_grid_values,
  t,
  dt,
  S0,
  instruments,
  stock_level_fcn,
  discount_factor_fcn,
  default_intensity_fcn,
  variance_cumulation_fcn,
  dividends = NULL
)
}
\arguments{
\item{z}{Space grid value morphable to stock prices using \code{stock_level_fcn}}

\item{prev_grid_values}{A matrix with one column for each
instrument and one row for each of the \eqn{N} values of \code{z}}

\item{t}{Time after this timestep has been taken}

\item{dt}{Interval to the end of this timestep}

\item{S0}{Time zero price of the base equity}

\item{instruments}{Instruments corresponding to layers of the value grid in \code{prev_grid_values}}

\item{stock_level_fcn}{A function for changing space grid value to stock
prices, with arguments \code{z} and \code{t}}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{default_intensity_fcn}{A function for computing default intensity
occurring during this timestep, dependent on time and stock price, with
arguments \code{t}, \code{S}.}

\item{variance_cumulation_fcn}{A function for computing total stock variance
occurring during this timestep, with arguments \code{T}, \code{t}.  E.g. with
a constant volatility \eqn{s} this takes the form \eqn{(T-t)s^2}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}}
}
\value{
Grid values after applying an implicit timestep
}
\description{
Backwardate grid values for all the given instruments from a set of grid
  values matched to time \code{t+dt} to form a new set of grid value as
  of time \code{t}.
}
\seealso{
Other Implicit Grid Solver: 
\code{\link{construct_implicit_grid_structure}()},
\code{\link{find_present_value}()},
\code{\link{form_present_value_grid}()},
\code{\link{infer_conforming_time_grid}()},
\code{\link{integrate_pde}()},
\code{\link{iterate_grid_from_timestep}()},
\code{\link{take_implicit_timestep}()}
}
\concept{Implicit Grid Solver}
