% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term_structures.R
\name{spot_to_df_fcn}
\alias{spot_to_df_fcn}
\title{Create a discount factor function from a yield curve}
\usage{
spot_to_df_fcn(yield_curve)
}
\arguments{
\item{yield_curve}{A data.frame with numeric columns \code{time} (in
increasing order) and \code{rate} (in natural units)}
}
\value{
A function taking two time arguments, which returns the discount factor from the second to the first
}
\description{
Use a piecewise constant approximation to the given spot curve to
 generate a function capable of returning corresponding discount factors
}
\examples{
disct_fcn = ragtop::spot_to_df_fcn(
  data.frame(time=c(1, 5, 10, 15),
             rate=c(0.01, 0.02, 0.03, 0.05)))
print(disct_fcn(1, 0.5))
}
