% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{penalty_with_intensity_link}
\alias{penalty_with_intensity_link}
\title{Helper function (volatility-normalized pricing error) for calibration of equity-linked default intensity}
\usage{
penalty_with_intensity_link(
  p,
  s,
  h,
  variance_instruments,
  variance_instrument_prices,
  variance_instrument_spreads,
  fit_instruments,
  fit_instrument_prices,
  fit_instrument_spreads,
  fit_instrument_weights,
  S0,
  num_time_steps = 30,
  const_short_rate = 0,
  discount_factor_fcn = function(T, t) {
     exp(-const_short_rate * (T - t))
 },
  ...,
  relative_spread_tolerance = 0.15,
  num_variance_time_steps = 30
)
}
\arguments{
\item{p}{Power of default intensity}

\item{s}{Proportion of constant default intensity}

\item{h}{Base default intensity}

\item{variance_instruments}{A list of instruments in strictly increasing order
of maturity, from which the volatility term structure will be inferred.  Once the
calibration is finished, the chosen parameters will reproduce the prices of
these instruments with fairly high precision.}

\item{variance_instrument_prices}{Central price targets for the variance instruments}

\item{variance_instrument_spreads}{Bid-offer spreads used to normalize errors
in variance instrument prices during term structure fitting}

\item{fit_instruments}{A list of instruments in any order, from which the
mispricing penalties used for judging fit quality will be computed}

\item{fit_instrument_prices}{Central price targets for the variance instruments}

\item{fit_instrument_spreads}{Bid-offer spreads used to normalize errors
in fit instrument prices during default intensity}

\item{fit_instrument_weights}{Weights applied to relative errors in fit
instrument prices before summing to form the penalty}

\item{S0}{Current underlying price}

\item{num_time_steps}{Time step count passed on to \code{\link{find_present_value}}
while fitting instrument values}

\item{const_short_rate}{A constant to use for the instantaneous interest rate in case \code{discount_factor_fcn}
is not given}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{...}{Further arguments passed to \code{\link{price_with_intensity_link}}}

\item{relative_spread_tolerance}{Tolerance to apply in
calling \code{\link{fit_variance_cumulation}}}

\item{num_variance_time_steps}{Number of time steps to use in
calling \code{\link{fit_variance_cumulation}}}
}
\description{
Given a set SDE parameters, form a volatility term structure that fairly precisely matches
  the supplied prices of the \code{variance_instruments}.  Then use that term structure and
  the default intensity to price all the \code{fit_instruments}, and compare them to the
  \code{fit_instrument_prices}.
}
\details{
Forms implied Black-Scholes volatilities from all supplied mid prices, and their
   implied bid and offer prices, as well as from the prices computed by the grid solver. Each
   instrument is then assigned an error term component in proportion to its weight
   and the pricing error (in implied vol terms) divided by the spread (also in implied
   vol terms).
}
\seealso{
\code{\link{price_with_intensity_link}} for the pricing function
}
