% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.rotate.by.regression.2.R
\name{with.ena.matrix}
\alias{with.ena.matrix}
\title{with.ena.matrix}
\usage{
\method{with}{ena.matrix}(data, expr, ...)
}
\arguments{
\item{data}{An ENA matrix or data frame containing the data to be used.}

\item{expr}{An R expression to be evaluated within the context of the ENA matrix.}

\item{...}{Additional arguments, including an optional custom matrix `V` and other parameters.}
}
\value{
The result of evaluating `expr` in the constructed context.
}
\description{
This function sets up a context using the provided data (typically an ENA matrix),
allowing the evaluation of an expression (`expr`) with access to both the matrix and
its metadata. Optionally, a custom matrix `V` and other arguments can be supplied.
}
\details{
- If a custom matrix `V` is provided in `...`, it will be used; otherwise, `data` is converted to a matrix.
- Metadata columns are coerced to numeric if they are character vectors.
- The expression is evaluated with access to both the matrix (`V`) and metadata.
}
