% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{accumulate}
\alias{accumulate}
\title{Accumulate Connection Counts for ENA}
\usage{
accumulate(
  x,
  units = rENA::units(x),
  codes = rENA::codes(x),
  horizon = rENA::horizon(x),
  ...,
  ordered = FALSE,
  binary = TRUE
)
}
\arguments{
\item{x}{A data.frame or similar object containing the data to be analyzed.}

\item{units}{A character vector specifying the columns that define the units of analysis.}

\item{codes}{A character vector specifying the columns that contain the codes for co-occurrence analysis.}

\item{horizon}{A character vector specifying the columns that define the conversational boundaries (horizon).}

\item{...}{Additional arguments passed to underlying accumulation functions.}

\item{ordered}{A logical value. If TRUE, creates ordered networks (A -> B is different from B -> A). Defaults to FALSE.}

\item{binary}{A logical value. If TRUE, connection counts are binarized (0 or 1). Defaults to TRUE.}
}
\value{
An ena.set object containing the accumulated connection counts and metadata.
}
\description{
This function takes a data.frame and accumulates co-occurrences of codes within specified units and conversations (horizon), preparing it for ENA. It's designed to be used with pipes (`|>`)..
}
\examples{
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon)

}
