% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_array.R
\name{write_array}
\alias{write_array}
\title{Write array component to HDF5 file}
\usage{
write_array(
  array,
  handle,
  data_product,
  component,
  description,
  dimension_names,
  dimension_values,
  dimension_units,
  units
)
}
\arguments{
\item{array}{an \code{array} containing the data}

\item{handle}{an object of class \code{fdp, R6} containing metadata required
by the Data Pipeline API}

\item{data_product}{a \code{string} specifying the name of the data product}

\item{component}{a \code{string} specifying a location within the hdf5 file}

\item{description}{a \code{string} describing the data product component}

\item{dimension_names}{a \code{list} where each element is a vector
containing the labels associated with a particular dimension (e.g.
element 1 corresponds to dimension 1, which corresponds to row names) and
the name of each element describes the contents of each dimension (e.g. age
classes).}

\item{dimension_values}{(optional) a \code{list} of values corresponding to
each dimension (e.g. list element 2 corresponds to columns)}

\item{dimension_units}{(optional) a \code{list} of units corresponding to
each dimension (e.g. list element 2 corresponds to columns)}

\item{units}{(optional) a \code{string} specifying the units of the data as
a whole}
}
\value{
Returns a handle index associated with the just written component,
which can be used to raise an issue if necessary
}
\description{
Function to populate hdf5 file with array type data.
}
\seealso{
Other write functions: 
\code{\link{write_distribution}()},
\code{\link{write_estimate}()},
\code{\link{write_table}()}
}
\concept{write functions}
