% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_bad_osm_ids}
\alias{validate_bad_osm_ids}
\title{Validate OSM IDs returned from Java backend and print warnings}
\usage{
validate_bad_osm_ids(bad_ids_string)
}
\arguments{
\item{bad_ids_string}{Character. A string formatted as a Java array (e.g., \code{"[id1, id2]"}).}
}
\value{
Warning if necessary.
}
\description{
Parses a Java-style array string (e.g., \code{"[id1, id2]"}), extracts OSM IDs,
and prints a pretty warning if any invalid IDs are found.
}
\details{
If no invalid IDs are found (i.e., input is \code{"[]"}), prints nothing.
}
\seealso{
Other support functions: 
\code{\link{exists_tiff}()},
\code{\link{fileurl_from_metadata}()},
\code{\link{start_r5r_java}()},
\code{\link{stop_r5}()},
\code{\link{tempdir_unique}()}
}
\concept{support functions}
\keyword{internal}
