% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_2dii.R
\name{theme_2dii}
\alias{theme_2dii}
\title{Complete theme}
\usage{
theme_2dii(
  base_size = 12,
  base_family = "Helvetica",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\value{
An object of class "theme", "gg".
}
\description{
A ggplot theme which can be applied to all graphs to appear according to the PACTA
plotting aesthetics.
}
\examples{
library(ggplot2, warn.conflicts = FALSE)

ggplot(mtcars) +
  geom_histogram(aes(mpg), bins = 10) +
  theme_2dii()
}
\seealso{
\link[ggplot2:ggtheme]{ggplot2::theme_classic}.
}
\concept{plotting functions}
