% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{gen_axes}
\alias{gen_axes}
\title{Generate Axes for Projection}
\usage{
gen_axes(
  proj,
  limits = 1,
  axis_pos_x = NULL,
  axis_pos_y = NULL,
  axis_labels,
  threshold = 0
)
}
\arguments{
\item{proj}{A projection matrix or data frame.}

\item{limits}{Numeric value specifying axis limits (default: 1).}

\item{axis_pos_x}{Optional numeric value for x-axis position.}

\item{axis_pos_y}{Optional numeric value for y-axis position.}

\item{axis_labels}{A vector of axis labels.}

\item{threshold}{A numeric threshold value (default: 0).}
}
\value{
A modified projection with added axis elements.
}
\description{
Generate Axes for Projection
}
\examples{
projection_df <- cbind(
c(-0.17353,-0.02906,0.19857,0.00037,0.00131,-0.05019,0.03371),
c(-0.10551,0.14829,-0.02063,0.02658,-0.03150,0.19698,0.00044))

gen_axes(proj = projection_df, axis_labels = paste0("x", 1:7))
}
