% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-subsetting.R
\name{head.dfm}
\alias{head.dfm}
\alias{tail.dfm}
\title{Return the first or last part of a dfm}
\usage{
\method{head}{dfm}(x, n = 6L, ...)

\method{tail}{dfm}(x, n = 6L, ...)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects).  A \code{logical} is silently coerced to
    integer.  Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
A \link{dfm} class object corresponding to the subset of documents
determined by by \code{n}.
}
\description{
For a \link{dfm} object, return the dfm with only the first or last \code{n} documents.
}
\examples{
head(data_dfm_lbgexample, 3)
head(data_dfm_lbgexample, -4)

tail(data_dfm_lbgexample)
tail(data_dfm_lbgexample, n = 3)
}
\keyword{dfm}
\keyword{internal}
