% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsavem-load.R
\name{qreadm}
\alias{qreadm}
\alias{qload}
\title{qload}
\usage{
qreadm(file, env = parent.frame(), ...)

qload(file, env = parent.frame(), ...)
}
\arguments{
\item{file}{The file name/path.}

\item{env}{The environment where the data should be loaded.}

\item{...}{additional arguments will be passed to qread.}
}
\value{
Nothing is explicitly returned, but the function will load the saved objects into the workspace.
}
\description{
Reads an object in a file serialized to disk using \code{\link[=qsavem]{qsavem()}}.
}
\details{
This function extends qread to replicate the functionality of \code{\link[base:load]{base::load()}} to load multiple saved objects into your workspace. \code{qload} and \code{qreadm} are alias of the same function.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
myfile <- tempfile()
qsavem(x1, x2, file=myfile)
rm(x1, x2)
qload(myfile)
exists('x1') && exists('x2') # returns true

# qs support multithreading
qsavem(x1, x2, file=myfile, nthreads=2)
rm(x1, x2)
qload(myfile, nthreads=2)
exists('x1') && exists('x2') # returns true
}
