% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/qfratio-package.R
\name{hyperg_1F1_vec_b}
\alias{hyperg_1F1_vec_b}
\alias{hyperg_2F1_mat_a_vec_c}
\alias{gsl_wrap}
\title{Internal C++ wrappers for \proglang{GSL}}
\usage{
hyperg_1F1_vec_b(a, bvec, x)

hyperg_2F1_mat_a_vec_c(Amat, b, cvec, x)
}
\arguments{
\item{a, b}{Parameters of hypergeometric functions; passed as \code{double}}

\item{bvec, cvec}{Parameters of hypergeometric functions; passed as
\code{Rcpp::NumericVector}}

\item{x}{Argument of hypergeometric functions; passed as \code{double}}

\item{Amat}{Parameter of hypergeometric functions; passed as
\code{Rcpp::NumericMatrix}.  Dimension must be square of the length of
\code{cvec}.}
}
\value{
Return a list via \code{Rcpp::List} of the following:
\describe{
\item{\code{$val}}{Evaluation result, numeric}
\item{\code{$err}}{Absolute error, numeric}
\item{\code{$status}}{Error code, integer}
}
In \code{hyperg_1F1_vec_b}, these are vectors from
\code{Rcpp::NumericVector} and \code{Rcpp::IntegerVector}, whereas in
\code{hyperg_2F1_mat_a_vec_c}, they are matrices
from \code{Rcpp::NumericMatrix} and \code{Rcpp::IntegerMatrix}.
}
\description{
These are internal \proglang{C++} functions which wrap hypergeometric
functions from \proglang{GSL} with vectorization.  These are for
particular use cases in this package, and direct access by the user is
\strong{not} assumed.
}
\section{Functions}{
\itemize{
\item \code{hyperg_1F1_vec_b()}: wrapper of \code{gsl_hyperg_1F1_e()}, looping along \code{bvec}

\item \code{hyperg_2F1_mat_a_vec_c()}: wrapper of \code{gsl_hyperg_2F1_e()}, looping along \code{Amat} and
recycling \code{cvec}

}}
