% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{sar.gc.coef}
\alias{sar.gc.coef}
\title{Extraction of SAR Coefficients for Granger-Causality Analysis}
\usage{
sar.gc.coef(fit, index = c(1, 2))
}
\arguments{
\item{fit}{object of SAR model from \code{qser2sar()} or \code{qspec.sar()$fit}}

\item{index}{a pair of component indices for multiple time series 
or a sequence of lags for single time series (default = \code{c(1,2)})}
}
\value{
matrix of selected SAR coefficients (number of lags by number of quantiles)
}
\description{
This function extracts the spline autoregression (SAR) coefficients from an SAR model for Granger-causality analysis.
See \code{sar.gc.bootstrap} for more details regarding the use of \code{index}.
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sar <- qspec.sar(cbind(y1,y2),tau0=tau,p=1)
A <- sar.gc.coef(y.sar$fit,index=c(1,2))
}
