% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_acrosscells.R
\name{px_cellnote}
\alias{px_cellnote}
\alias{px_cellnote.px}
\title{CELLNOTE}
\usage{
px_cellnote(x, value, na_to_star, validate)

\method{px_cellnote}{px}(x, value, na_to_star = TRUE, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A data frame with columns 'cellnote' and one or more columns with the names of the STUB and HEADING variables. The 'cellnote' column is the cellnote text, and the STUB/HEADING columns control which cells the note applies to. Use star (*) if a note applies to all cells in a variable. Use column 'language'  to set CELLNOTE for specific languages. If 'value' is missing, the current CELLNOTE is returned. If value is NULL, CELLNOTE is removed.}

\item{na_to_star}{Optional. Convert all NAs to '*'.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change CELLNOTE.
}
\examples{
# Set CELLNOTE for a value
library(tibble)
x1 <-
  population_gl |>
  px() |>
  px_cellnote(
    tribble(~gender,  ~age,  ~year, ~cellnote,
             'male', '0-6', '2004', 'Approximation'))

x2 <-
  x1 |>
  px_cellnote(
    tribble(~gender,   ~age,  ~year, ~cellnote,
           'female',    '*', '2014', 'Uncertainty in ages'))

# Print CELLNOTE
px_cellnote(x2)

# Set CELLNOTE in multiple languagese
x3 <-
  x1 |>
  px_languages(c('en', 'kl')) |>
  px_cellnote(
    tribble(~age, ~year, ~language, ~cellnote,
             '*', '2003',  'en', 'Some of the figures are from 2003',
             '*', '2003', 'kl', 'Kisitsisit ilaat 2003-imeersuupput'))
px_cellnote(x3)

# Remove CELLNOTE
x4 <- px_cellnote(x3, NULL)
px_cellnote(x4)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A40\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C460\%2C0\%5D}{Statistics Sweden's documentation}
}
