% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{DAG.to.MAG.in.pwSEM}
\alias{DAG.to.MAG.in.pwSEM}
\title{Title DAG.to.MAG.in.pwSEM}
\usage{
DAG.to.MAG.in.pwSEM(full.DAG, latents = NA, conditioning.latents = NULL)
}
\arguments{
\item{full.DAG}{The DAG with latent variables, usually produced with the
DAG() function of the ggm package}

\item{latents}{A character vector giving the names of the latent variables
in the DAG}

\item{conditioning.latents}{A character vector giving the names
of those latents, listed in the "latents" argument, that serve as
conditioning variables for sampling (i.e. selection bias).}
}
\value{
A binary (0/1) matrix holding the MAG
}
\description{
Title DAG.to.MAG.in.pwSEM
}
\examples{
library(ggm)
full.dag<-DAG(x1~L1,x2~x1,x3~x2+L1,x4~x3,L2~x2+x4)
DAG.to.MAG.in.pwSEM(full.DAG=full.dag,latents=c("L1","L2"),
conditioning.latents=c("L2"))
}
