% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withdrawal.R
\docType{data}
\name{withdrawal}
\alias{withdrawal}
\title{Patient Withdrawal Symptoms Per Day}
\format{
A tibble with 14,983 rows and
3 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{withdrawal}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = 0) \cr
    \tab  \cr
   \emph{Description:} \tab \if{html}{\out{<ul>}}\if{html}{\out{<li>}}0 = "None"\if{html}{\out{</li>}}\if{html}{\out{<li>}}1 = "mild"\if{html}{\out{</li>}}\if{html}{\out{<li>}}2 = "moderate"\if{html}{\out{</li>}}\if{html}{\out{<li>}}3 = "severe"\if{html}{\out{</li>}}\if{html}{\out{</ul>}} \cr
    \tab  \cr
   \emph{Levels:} \tab 0, 1, 2, 3 \cr
}


}
\item{\strong{when}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Study day \cr
}


}
}
}
\source{
Clinical Opiate Withdrawal Scale (COWS)
\href{https://nida.nih.gov/sites/default/files/ClinicalOpiateWithdrawalScale.pdf}{Wesson, DR, & Ling, W. (2003)}

Subjective Opiate Withdrawal Scale (SOWS)
\href{https://www.asam.org/docs/default-source/education-docs/sows_8-28-2017.pdf}{Handelsman L, Cochrane KJ, Aronson MJ, Ness R, Rubinstein KJ, Kanof, PD (1987). Two New Rating Scales for Opiate Withdrawal. The American journal of drug and alcohol abuse, 1987, Vol.13 (3), p.293-308}
}
\usage{
data(withdrawal)
}
\description{
CTN 27 and 30 use the Clinical Opiate Withdrawal Scale (COWS).
CTN 51 uses SOWS. See harmonization vignette for more details.
}
\keyword{datasets}
