% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_drugs.R
\docType{data}
\name{all_drugs}
\alias{all_drugs}
\title{All drugs taken}
\format{
A tibble with 307,523 rows and
4 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{what}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Acetaminophen) \cr
    \tab  \cr
   \emph{Description:} \tab Name of drug (or alcohol) from self-reported or drug screening \cr
    \tab  \cr
   \emph{Levels:} \tab Acetaminophen, Alcohol, Amphetamine, Antibiotic, Antidepressant, Antiemetic, Antihistamine, Antipsychotic, Barbiturate, Benadryl, Benzodiazepine, Buprenorphine, Caffeine, Cathinones, Clonidine, Cocaine, Codeine, Crack, Dextromethorphan, Fentanyl, Gabapentin, Ghb, Hallucinogen, Heavy Drinking, Heroin, Hydrocodone, Hydromorphone, Inhalant, K2, Kratom, Light Drinking, Mdma, Merperidine, Methadone, Methamphetamine, Methylphenidate, Morphine, Musclerelax, Nalbuphine, Opioid, Opium, Oxycodone, Oxymorphone, Pcp, Propoxyphene, Pseudoephedrine, Sedative-Hypnotic, Suboxone, Thc, Tramadol, Trazodone, Tryclic-Antidepressant, Unknown \cr
}


}
\item{\strong{source}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = TFB) \cr
    \tab  \cr
   \emph{Description:} \tab Source of reported drug use. TLFB = Timeline Follow Back; UDS = Urine Drug Screening; UDSAB = Urine Drug Screening & Alcohol Breathalyzer \cr
    \tab  \cr
   \emph{Levels:} \tab TFB, UDS, UDSAB \cr
}


}
\item{\strong{when}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Study day \cr
}


}
}
}
\usage{
data(all_drugs)
}
\description{
This is a record of both self-reported drug use and positive
drug screening results.  See the vignette
\href{../doc/harmonization.html}{Harmonization Information} for more details.
}
\keyword{datasets}
