% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{factorComposite}
\alias{factorComposite}
\title{Score Data Using a Factor Model}
\usage{
factorComposite(
  object,
  type = c("onefactor", "secondorderfactor", "bifactor"),
  factors = list(NA_character_)
)
}
\arguments{
\item{object}{An object of class \code{CompositeReady}}

\item{type}{A character string indicating the type of factor model to use}

\item{factors}{A named list where names are the factor names and each
element is a character string of the indicator names.}
}
\value{
An S4 object of class \code{FactorScores}.
}
\description{
Create a composite using a Factor Model
}
\examples{
# this example creates distances for the built in mtcars data
# see ?mtcars for more details
# The distances are calculated from the "best" in the dataset
# First we create an appropriate CompositeData class object
# higher mpg & hp are better and lower wt & qsec are better
d <- CompositeData(mtcars[, c("mpg", "hp", "wt", "qsec")],
  thresholds = list(one = with(mtcars, c(
    mpg = max(mpg),
    hp = max(hp),
    wt = min(wt),
    qsec = min(qsec)))
  ),
  higherisbetter = c(TRUE, TRUE, FALSE, FALSE))

# create the distance scores
# and the composite
# covariance matrix will be calculated from the data
# and data will be standardized to unit variance by default
dres <- prepareComposite(d)

# see a density plot of the distance scores
dres@distanceDensity
# regular summary of distance scores
summary(dres@distances)

# examine covariance matrix
round(dres@covmat,2)

# now we can create the composite based on summing the (standardized)
# distances from our defined thresholds
# by default, distances are squared, then summed, and then square rooted
# to be back on the original scale
fcomp <- factorComposite(dres, type = "onefactor")

# view a histogram of the composite scores
fcomp@scoreHistogram

# summarize the composite scores
summary(fcomp@scores)

\dontrun{
# we can also fit a second-order factor model
# there are not enough indicators to identify the factor
# and so lavaan gives us warning messages
fcomp2 <- factorComposite(dres, type = "secondorderfactor",
  factors = list(speed = c("hp", "qsec")))

# view a histogram of the composite scores
fcomp2@scoreHistogram

# summarize the composite scores
summary(fcomp2@scores)

# compare one and second-order factor model scores
plot(fcomp@scores, fcomp2@scores)

# cleanup
rm(d, dres, fcomp, fcomp2)
}
}
\seealso{
Other composite: 
\code{\link{mahalanobisComposite}()},
\code{\link{sumComposite}()}
}
\concept{composite}
