% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refmodel.R
\name{y_wobs_offs}
\alias{y_wobs_offs}
\title{Extract response values, observation weights, and offsets}
\usage{
y_wobs_offs(newdata, wrhs = NULL, orhs = NULL, resp_form)
}
\arguments{
\item{newdata}{The \code{data.frame} from which at least the response values
should be extracted.}

\item{wrhs}{Either a right-hand side formula consisting only of the variable
in \code{newdata} containing the weights, \code{NULL} (for using a vector of ones),
or directly the numeric vector of observation weights.}

\item{orhs}{Either a right-hand side formula consisting only of the variable
in \code{newdata} containing the offsets, \code{NULL} (for using a vector of zeros),
or directly the numeric vector of offsets.}

\item{resp_form}{If this is a formula, then the second element of this
formula (if the formula is a standard formula with both left-hand and
right-hand side, then its second element is the left-hand side; if the
formula is a right-hand side formula, then its second element is the
right-hand side) will be extracted from \code{newdata} (so \code{resp_form} may be
either a standard formula or a right-hand side formula, but in the latter
case, the right-hand side should consist only of the response variable). In
all other cases, \code{NULL} will be returned for element \code{y} of the output
\code{list}.}
}
\value{
A \code{list} with elements \code{y}, \code{weights}, and \code{offset}, each being a
numeric vector containing the data for the response, the observation
weights, and the offsets, respectively. An exception is that \code{y} may also
be \code{NULL} (depending on argument \code{resp_form}), a non-numeric vector, or a
\code{factor}.
}
\description{
A helper function for extracting response values, observation weights, and
offsets from a dataset. It is designed for use in the \code{extract_model_data}
function of custom reference model objects (see \code{\link[=init_refmodel]{init_refmodel()}}).
}
\seealso{
\code{\link[=init_refmodel]{init_refmodel()}}
}
