% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_bounds.R
\name{post_sens}
\alias{post_sens}
\title{Run sensitivity analysis on post-measurement design}
\usage{
post_sens(
  formula,
  data,
  moderator,
  g_by,
  g_max = 1,
  q_by,
  sims = 1000,
  conf_level = 0.95,
  moderator_mono = NULL,
  stable_mod = FALSE,
  progress = TRUE,
  solver = "Rglpk"
)
}
\arguments{
\item{formula}{A formula with syntax \code{y ~ t}, where \code{y} is the
(unquoted) name of the outcome and \code{t} is the (unquoted) name of the treatment.}

\item{data}{A data.frame containing variables in the formula, moderator, and covariates arguments.}

\item{moderator}{A one-sided formuala with syntax \code{~ d}, where \code{d}
is the (unquoted) name of the  moderator variable for the CATE.}

\item{g_by}{Numeric indicating the grid spacing for the
\eqn{\gamma} parameter that places an upper bound on the proportion
of units whose moderator is affected by treatment.}

\item{g_max}{Numeric indicating the maximum value of the \eqn{\gamma} parameter.}

\item{q_by}{Numeric indicating the grid spacing for the mean of the
moderator under a pre-test measurement.}

\item{sims}{An integer indicating the number of simulations for the
bootstrap confidence intervals for the bounds.}

\item{conf_level}{A numeric indicating the confidence level for the
bootstrap confidence intervals.}

\item{moderator_mono}{A integer or vector of length 2 indicating
if the bounds should assume monotonicity of the effect of the
post-test on the moderator with \code{1} indicating that the post-test
effect is positive and \code{-1} indicating that it is negative. The
vector of length 2 allows the monotonicity assumption to vary by
treatment status with the first entry being for control and the
second for treated.}

\item{stable_mod}{A logical value indicating if the bounds should
assume that the moderator is unaffected by pre-vs-post measurement
under the control condition.}

\item{progress}{A logical indicating if progress bars should be
displayed. Defaults to TRUE.}

\item{solver}{A character indicating what linear programming solver to use:
"Rglpk" (the default) or "lpSolve".}
}
\value{
A list object containing sensitivity output.
}
\description{
Run sensitivity analysis on post-measurement design
}
\examples{
data(delponte)
post_sens(formula = angry_bin ~ t_commonality,
  data = delponte,
  moderator = ~ itaid_bin,
  g_by = 0.1,
  sims = 50
)
}
