% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{matrix_to_list_of_cols}
\alias{matrix_to_list_of_cols}
\alias{matrix_to_list_of_rows}
\title{Turn a Matrix Into a List of Columns or Rows}
\usage{
matrix_to_list_of_cols(m)

matrix_to_list_of_rows(m)
}
\arguments{
\item{m}{A matrix}
}
\value{
\itemize{
\item \code{matrix_to_list_of_cols()} A list of vectors,
each of which is a column from \code{x}.
\item \code{matrix_to_list_of_rows()}, A list of vectors,
each of which is a row from \code{x}.
}
}
\description{
Given a matrix, create a list, each element of which contains
a column or row from the matrix.
}
\details{
\code{matrix_to_list_of_cols()} and `matrix_to_list_of_rows() are
internal functions, for use by developers, and would not
normally be called directly by end users.
}
\examples{
m <- matrix(1:12, nrow = 3)
matrix_to_list_of_cols(m)
matrix_to_list_of_rows(m)
}
