% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age_lower}
\alias{age_lower}
\alias{age_mid}
\alias{age_upper}
\title{Lower Limits, Midpoints, and Upper Limits of Age Groups}
\usage{
age_lower(x)

age_mid(x)

age_upper(x)
}
\arguments{
\item{x}{A vector of age group labels.}
}
\value{
A numeric vector, the same length as \code{x}.
}
\description{
Given a vector \code{x} of age group labels, return
a numeric vector.
\itemize{
\item \code{age_lower()} returns the lower limits of each age group,
\item \code{age_mid()} returns the midpoints, and
\item \code{age_upper()} returns the upper limits.
}

Vector \code{x} must describe 1-year, 5-year or life-table
age groups: see \code{\link[=age_labels]{age_labels()}} for examples. \code{x} can
format these age groups in any way understood by
\code{\link[=reformat_age]{reformat_age()}}.
}
\details{
These functions can make age groups easier to work
with. Lower and upper limits can be used for
selecting on age. Replacing age group with midpoints
can improve graphs.
}
\examples{
x <- c("15-19", "5-9", "50+")
age_lower(x)
age_mid(x)
age_upper(x)

## non-standard formats are OK
age_lower(c("infants", "100 and over"))

df <- data.frame(age = c("1-4", "10-14", "5-9", "0"),
                 rate = c(0.023, 0.015, 0.007, 0.068))
df
subset(df, age_lower(age) >= 5)
}
\seealso{
\code{\link[=reformat_age]{reformat_age()}} \code{\link[=age_labels]{age_labels()}}
}
