% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lifetable.R
\name{Lifetable}
\alias{Lifetable}
\title{Life Table}
\usage{
Lifetable(
  rates,
  pops,
  sex,
  max_age = NULL,
  first_year,
  threshold,
  jump,
  element = c("mx", "qx", "lx", "dx", "Lx", "Tx", "ex", "rx"),
  ...
)
}
\arguments{
\item{rates}{character. A character string that specifies mortality data path. The dataset is a .txt file like \code{CR_mortality_rates_2010_2015} dataset.}

\item{pops}{character. A character string that specifies population data path. The dataset is a .txt file like \code{CR_populations_1950_2015} dataset.}

\item{sex}{character. "female" or "male".}

\item{max_age}{numeric. Desire omega age. If \code{NULL}, \code{Lifetable} function takes the dataset's maximum age.}

\item{first_year}{numeric. First year to start estimation.}

\item{threshold}{numeric. Maximum forecast year.}

\item{jump}{character. Same purpose to \code{jumpchoice} argument in \code{\link[forecast]{forecast}} function.}

\item{element}{character. Wanted estimation element, one of "mx", "qx", "lx", "dx", "Lx", "Tx", "ex" or "rx".}

\item{...}{additional arguments to be passed to \code{\link[demography]{read.demogdata}}, such as \code{label}.}
}
\value{
\code{Lifetable} function returns a list with both data frames, wide and long format, for specified element in argument \code{element} for desire years.
}
\description{
Estimates a lifetable from mortality rates and population data.
}
\examples{

\donttest{
\dontrun{
 write.table(CR_mortality_rates_2010_2015,
 file = "CR_mortality_rates_2010_2015.txt",
 sep = "\t", row.names = FALSE, quote = FALSE)

 write.table(CR_populations_1950_2015,
 file = "CR_populations_1950_2015.txt",
 sep = "\t", row.names = FALSE, quote = FALSE)

 Lifetable("CR_mortality_rates_2010_2015.txt", "CR_populations_1950_2015.txt",
 sex="female", first_year=2011, threshold=2150, jump="actual", max_age = 100,
 element="ex", label="CR")
}
}
}
\references{
\insertRef{Lifetable}{popstudy}
}
\author{
Cesar Gamboa-Sanabria
}
