% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spans.R
\name{get_spans_params}
\alias{get_spans_params}
\title{Gets the parameters for the highest ranked methods from spans.}
\usage{
get_spans_params(SPANSRes_obj, sort_by_nmols = FALSE)
}
\arguments{
\item{SPANSRes_obj}{an object of the class SPANSRes obtained by calling
\code{spans_procedure()}}

\item{sort_by_nmols}{a logical indicator of whether to sort by number of
molecules used in the normalization (see \code{\link{spans_procedure}} for
info about the 'mols_used_in_norm' column)}
}
\value{
A list of lists, where there are multiple sublists only if there were
  ties for the top SPANS score.  Each sublist contains named elements for the
  subset and normalization methods, and the parameters used for the subset
  method. \cr
}
\description{
Gets the parameters for the highest ranked methods from spans.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)

# data must be log transformed and grouped
myobject <- edata_transform(omicsData = pep_object, data_scale = "log2")
myobject <- group_designation(omicsData = myobject, main_effects = "Phenotype")

spans_result <- spans_procedure(omicsData = myobject)

# a list of the parameters for any normalization procedure with the best SPANS score
best_params <- get_spans_params(spans_result)

# extract the arguments from the first list element
subset_fn = best_params[[1]]$subset_fn
norm_fn = best_params[[1]]$norm_fn
params = best_params[[1]]$params
if (is.null(params[[1]])) {
  params = NULL
}

# pass arguments to normalize global
norm_object <- normalize_global(omicsData = myobject, subset_fn = subset_fn,
                                norm_fn = norm_fn, params = params)
}
\dontshow{\}) # examplesIf}
}
