% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapes.R
\name{utils_shapes}
\alias{utils_shapes}
\alias{draw_circle}
\alias{draw_square}
\alias{draw_rectangle}
\alias{draw_trian_equi}
\alias{draw_trian_rect}
\alias{draw_n_tagon}
\title{Utilities for drawing coordinates of known shapes}
\usage{
draw_circle(radius = 1, n = 1000, plot = TRUE)

draw_square(side = 2, plot = TRUE)

draw_rectangle(side1 = 2, side2 = 3, plot = TRUE)

draw_trian_equi(side = 2, plot = TRUE)

draw_trian_rect(cat1 = 1, cat2 = 2, plot = TRUE)

draw_n_tagon(n, plot = TRUE)
}
\arguments{
\item{radius}{The radius of the circle. Defaults to \code{1}.}

\item{n}{The number of sides in the \code{n}-tagon.}

\item{plot}{Plots the result? Defaults to \code{TRUE}.}

\item{side}{The side of the square/equilateral triangle. Defaults to \code{2}.}

\item{side1, side2}{The first and second sides of the rectangle. Defaults to
\code{2} and \code{3}, respectively.}

\item{cat1, cat2}{The first and second cathetus of the right triangle.
Defaults to \code{1}, and \code{2}, respectively.}
}
\value{
A data frame with the \code{x} and \code{y} coordinates
}
\description{
The functions computes the coordinates of common shapes such as
squares triangles, rectangles and circles.
\itemize{
\item \code{draw_circle()} Draws a perfect circle with a desired radius.
\item \code{draw_square()} Draws a square with a desired side.
\item \code{draw_rectangle()} Draws a rectangle given two desired sides.
\item \code{draw_trian_equi()} Draws an equilateral triangle with a desired side.
\item \code{draw_trian_rect()} Draws a triangle rectangle given two cathetus.
\item \code{draw_n_tagon()} Draws polygons with \code{n} sides
}
}
\examples{
########## An example of a circle ##########
library(pliman)
radius <- 3
circ <- draw_circle(radius = radius)

# area
pi * radius ^ 2
poly_area(circ)

# perimeter
2 * pi * radius
poly_perimeter(circ)

############ An example of a square ############
side <- 2
(square <- draw_square(side = side))

# area
side ^ 2
poly_area(square)

# perimeter
side * 4
poly_perimeter(square)

############ An example of a rectangle ############
side1 <- 2
side2 <- 3
(rect <- draw_rectangle())

# area
poly_area(rect)

# perimeter
poly_perimeter(rect)
###########  An example of an equilateral triangle #########
side <- 1 # defaults
(trig <- draw_trian_equi(side = side))

### area (b*h / 2)
# height of the triangle
(h <- (side * sqrt(3)) / 2)
side * h / 2

poly_area(trig)

### perimeter (side * 3)
poly_perimeter(trig)

########### An example of a rectangle triangle ##########
cat1 <- 2
cat2 <- 3
(df <- draw_trian_rect(cat1, cat2))
# area
(cat1 * cat2) / 2
poly_area(df)

# perimeter
cat1 + cat2 + sqrt(cat1^2 + cat2^2)
poly_perimeter(df)
############ An creating shapes with n sides ############
side <- 2
(square <- draw_square(side = side))

# area
side ^ 2
poly_area(square)

# perimeter
side * 4
poly_perimeter(square)
}
