% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldsc_h2.R
\name{ldsc_h2}
\alias{ldsc_h2}
\title{Estimate heritability - refer to ldscr R package (https://github.com/mglev1n/ldscr)}
\usage{
ldsc_h2(
  munged_sumstats,
  sample_prev = NA,
  population_prev = NA,
  ld,
  wld,
  n_blocks = 200,
  chisq_max = NA,
  chr_filter = seq(1, 22, 1)
)
}
\arguments{
\item{munged_sumstats}{Either a dataframe, or a path to a file containing munged summary statistics. Must contain at least columns named `SNP` (rsid), `A1` (effect allele), `A2` (non-effect allele), `N` (total sample size) and `Z` (Z-score)}

\item{sample_prev}{(numeric) For binary traits, this should be the prevalence of cases in the current sample, used for conversion from observed heritability to liability-scale heritability. The default is `NA`, which is appropriate for quantitative traits or estimating heritability on the observed scale.}

\item{population_prev}{(numeric) For binary traits, this should be the population prevalence of the trait, used for conversion from observed heritability to liability-scale heritability. The default is `NA`, which is appropriate for quantitative traits or estimating heritability on the observed scale.}

\item{ld}{(character) Path to directory containing ld score files, ending in `*.l2.ldscore.gz`.}

\item{wld}{(character) Path to directory containing weight files.}

\item{n_blocks}{(numeric) Number of blocks used to produce block jackknife standard errors. Default is `200`}

\item{chisq_max}{(numeric) Maximum value of Z^2 for SNPs to be included in LD-score regression. Default is to set `chisq_max` to the maximum of 80 and N*0.001.}

\item{chr_filter}{(numeric vector) Chromosomes to include in analysis. Separating even/odd chromosomes may be useful for exploratory/confirmatory factor analysis.}
}
\value{
A [tibble][tibble::tibble-package] containing heritability information. If `sample_prev` and `population_prev` were provided, the heritability estimate will also be returned on the liability scale.
}
\description{
`ldsc_h2()` uses ldscore regression to estimate the heritability of a trait from GWAS summary statistics and reference LD information.
}
