% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqsdocs.R
\name{sysreqs_is_supported}
\alias{sysreqs_is_supported}
\title{Check if a platform has system requirements support}
\usage{
sysreqs_is_supported(sysreqs_platform = NULL)
}
\arguments{
\item{sysreqs_platform}{System requirements platform. If \code{NULL}, then the
\code{sysreqs_platform} \eval{man_config_link("configuration option")}
is used, which defaults to the current platform. Set this option if
\eval{.packageName} does not detect your platform correctly.}
}
\value{
Logical scalar.
}
\description{
Check if a platform has system requirements support
}
\examples{
\dontshow{if (Sys.getenv("IN_PKGDOWN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sysreqs_is_supported()
\dontshow{\}) # examplesIf}
}
\seealso{
The \code{sysreqs_platform}
\eval{man_config_link("configuration option")}.

Other system requirements functions: 
\code{\link{sysreqs_check_installed}()},
\code{\link{sysreqs_db_list}()},
\code{\link{sysreqs_db_match}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_install_plan}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{system requirements functions}
