% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Piecemeal.R
\name{init}
\alias{init}
\title{A convenience function for initialising \code{\link{Piecemeal}} objects.}
\usage{
init(outdir)
}
\arguments{
\item{outdir}{the directory to hold the partial simulation results.}
}
\value{
A \code{\link{Piecemeal}} object.
}
\description{
There is rarely a reason to attach \pkg{piecemeal} via \code{\link[=library]{library()}}, so \code{piecemeal::init(outdir)} is provided as shorthand for \code{\link{Piecemeal}}\verb{$new(outdir)}.
}
\examples{
outdir <- file.path(tempdir(), "piecemeal_demo")
sim <- piecemeal::init(outdir)
# a.k.a. piecemeal::Piecemeal$new(outdir)
# a.k.a.
# library(piecemeal)
# Piecemeal$new(outdir)
}
\seealso{
\code{\link{Piecemeal}}
}
