% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avgLadder.R
\name{avgLadder}
\alias{avgLadder}
\title{Average ladder size}
\usage{
avgLadder(tree, normalise = FALSE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result, default is \code{FALSE}}
}
\value{
The mean ladder size
}
\description{
Finds the mean size of ladders in the tree
}
\examples{
## Find the average ladder size in a random tree with 20 tips:
tree <- rtree(20)
plot(tree)
avgLadder(tree)
# and the normalised average ladder size:
avgLadder(tree, normalise=TRUE)


}
\seealso{
\code{\link{ladderSizes}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
