% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setWhenMeasured}
\alias{setWhenMeasured}
\alias{when_measured<-}
\alias{setWhenMeasured.default}
\alias{setWhenMeasured.generic_spct}
\alias{setWhenMeasured.summary_generic_spct}
\alias{setWhenMeasured.data.frame}
\alias{setWhenMeasured.generic_mspct}
\title{Set the "when.measured" attribute}
\usage{
setWhenMeasured(x, when.measured, ...)

when_measured(x) <- value

\method{setWhenMeasured}{default}(x, when.measured, ...)

\method{setWhenMeasured}{generic_spct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)

\method{setWhenMeasured}{summary_generic_spct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)

\method{setWhenMeasured}{data.frame}(x, when.measured = lubridate::now(tzone = "UTC"), ...)

\method{setWhenMeasured}{generic_mspct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)
}
\arguments{
\item{x}{an R object}

\item{when.measured, value}{POSIXct to add as attribute, or a list of POSIXct.}

\item{...}{Allows use of additional arguments in methods for other classes.}
}
\value{
\code{x}, with its \code{"when.measured"} set.
}
\description{
Method to set by reference the \code{"when.measured"} attribute  of an R
object.
}
\details{
This method alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not an object of a supported
  class, \code{x} is not modified. If the arguments to \code{"when.measured"}
  or \code{value} are not a \code{POSIXct} object or \code{NULL} an error is
  triggered. A \code{POSIXct} describes an instant in time (date plus
  time-of-day plus time zone).

  Be aware that \code{lubridate::ymd()} returns an incompatible \code{Date}
  object while \code{lubridate::ymd_h()}, \code{lubridate::ymd_hm()} and
  \code{lubridate::ymd_hms()} and similar functions return objects of class
  \code{POSIXct} acceptable as arguments for parameter \code{when.measured}.
}
\section{Methods (by class)}{
\itemize{
\item \code{setWhenMeasured(default)}: default

\item \code{setWhenMeasured(generic_spct)}: generic_spct

\item \code{setWhenMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{setWhenMeasured(data.frame)}: data.frame

\item \code{setWhenMeasured(generic_mspct)}: generic_mspct

}}
\examples{
my.spct <- sun.spct
when_measured(my.spct)
when_measured(my.spct) <- lubridate::ymd_hms("2020-01-01 08:00:00")
when_measured(my.spct)
when_measured(my.spct) <- NULL
when_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
