% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s.e.irrad2rgb.r
\name{s_e_irrad2rgb}
\alias{s_e_irrad2rgb}
\title{Spectral irradiance to rgb color conversion}
\usage{
s_e_irrad2rgb(
  w.length,
  s.e.irrad,
  sens = photobiology::ciexyzCMF2.spct,
  color.name = NULL,
  check = TRUE
)
}
\arguments{
\item{w.length}{numeric vector of wavelengths (nm).}

\item{s.e.irrad}{numeric vector of spectral irradiance values.}

\item{sens}{a chroma_spct object with variables w.length, x, y, and z, giving
the CC or CMF definition (default is the proposed human CMF according to
CIE 2006.).}

\item{color.name}{character string for naming the rgb color definition.}

\item{check}{logical indicating whether to check or not spectral data.}
}
\value{
A color defined using \code{\link[grDevices]{rgb}}. The numeric
  values of the RGB components can be obtained using function
  \code{\link[grDevices]{col2rgb}}.
}
\description{
Calculates rgb values from spectra based on human color matching functions
(CMF) or chromaticity coordinates (CC). A CMF takes into account luminous
sensitivity, while a CC only the color hue. This function, in contrast to
that in package pavo does not normalize the values to equal luminosity, so
using a CMF as input gives the expected result. Another difference is that it
allows the user to choose the chromaticity data to be used. The data used by
default is different, and it corresponds to the whole range of CIE standard,
rather than the reduced range 400 nm to 700 nm. The wavelength limits are not
hard coded, so the function could be used to simulate vision in other
organisms as long as pseudo CMF or CC data are available for the simulation.
}
\note{
Very heavily modified from Chad Eliason's
  \email{cme16@zips.uakron.edu} spec2rgb function in package \code{Pavo}.
}
\examples{
my.color <-
    with(sun.data,
         s_e_irrad2rgb(w.length, s.e.irrad, color.name = "sunWhite"))
col2rgb(my.color)

}
\references{
CIE(1932). Commission Internationale de l'Eclairage Proceedings,
  1931. Cambridge: Cambridge University Press.

Color matching functions obtained from Colour and Vision Research
Laboratory online data repository at \url{http://www.cvrl.org/}.
}
\seealso{
Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{calc_multipliers}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{insert_hinges}()},
\code{\link{integrate_xy}()},
\code{\link{interpolate_spectrum}()},
\code{\link{irradiance}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photon_ratio}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
