% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnRI_norm.R
\name{LnRI_norm}
\alias{LnRI_norm}
\title{Return a remigration interval.}
\usage{
LnRI_norm(data, x, kl = NULL)
}
\arguments{
\item{data}{Data with remigration intervals}

\item{x}{Vector of parameters}

\item{kl}{Maximum number of years for remigration intervals.}
}
\value{
Return a remigration interval.\cr
}
\description{
Model of remigration interval\cr
The vector of parameters must include:\cr
sx, survival for year x\cr
if s is included, all years have the same survival\cr
tx, Tag retention for year x\cr
rx, probability of return for year x\cr
cx, probability of return for year x\cr
px, probability of observation for year x\cr
}
\details{
lnRI_norm returns a ln L
}
\examples{
\dontrun{
library(phenology)
# Example
# Each year a fraction of 0.9 is surviving
s <- c(s1=0.9, s2=0.9, s3=0.9, s4=0.9, s5=0.9)
# Probability of tag retention; 0.95 the first year then after no loss
t <- c(t1=0.95, t2=1, t3=1, t4=1, t5=1)
# Time-conditional return probability - This is the true remigration rate
r <- c(r1=0.1, r2=0.8, r3=0.7, r4=0.7, r5=1)
# Capture probability
p <- c(p1=0.6, p2=0.6, p3=0.6, p4=0.6, p5=0.6)
# Number of observations for 400 tagged females after 1, 2, 3, 4, and 5 years
OBS <- c(400, 10, 120, 40, 20, 10)
# Likelihood of the observed number based on the model
LnRI_norm(data=OBS, x = c(s, t, r, p, sd=2) )
LnRI_norm(data=OBS, x = c(s=0.97, t, r, p, sd=2) )

}
}
\seealso{
Other Model of Remigration Interval: 
\code{\link{Bayesian.remigration}()},
\code{\link{RI}()},
\code{\link{RI2BP}()},
\code{\link{plot.Remigration}()}
}
\author{
Marc Girondot
}
\concept{Model of Remigration Interval}
