% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_season.R, R/season_mov.R
\name{season}
\alias{season}
\alias{stat_season}
\title{Growing season division}
\usage{
season(
  INPUT,
  rFUN,
  wFUN,
  iters = 2,
  wmin = 0.1,
  lambda,
  nf = 3,
  frame = floor(INPUT$nptperyear/5) * 2 + 1,
  minpeakdistance = NULL,
  ypeak_min = 0.1,
  r_max = 0.2,
  r_min = 0.05,
  rtrough_max = 0.6,
  MaxPeaksPerYear = 2,
  MaxTroughsPerYear = 3,
  calendarYear = FALSE,
  adj.param = TRUE,
  rm.closed = TRUE,
  is.continuous = TRUE,
  .check_season = TRUE,
  verbose = FALSE,
  ...
)

stat_season(INPUT, d_fit)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{rFUN}{character, the name of rough curve fitting function, can be one of
c("smooth_wSG", "smooth_wWHIT", "smooth_wHANTS"), which are corresponding to
\code{\link[=smooth_wSG]{smooth_wSG()}}, \code{\link[=smooth_wWHIT]{smooth_wWHIT()}} and \code{\link[=smooth_wHANTS]{smooth_wHANTS()}}.}

\item{wFUN}{weights updating function, can be one of .}

\item{iters}{integer, the number of rough fitting iterations}

\item{wmin}{double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{lambda}{The smoothing parameter of \code{\link[=smooth_wWHIT]{smooth_wWHIT()}}. For
\code{\link[=season_mov]{season_mov()}}, if lambda is \code{NULL}, \code{\link[=init_lambda]{init_lambda()}}
will be used. Generally, it was set as 10000, 15, and 5 for daily, 8-day
and 16-day inputs respectively.}

\item{nf}{The parameter of \code{\link[=smooth_wHANTS]{smooth_wHANTS()}}, number of frequencies to be
considered above the zero frequency.}

\item{frame}{The parameter of \code{\link[=smooth_wSG]{smooth_wSG()}}, moving window size. Suggested by
TIMESAT, default \code{frame = floor(nptperyear/7)*2 + 1}.}

\item{minpeakdistance}{double, in points (default as
\code{nptperyear/6}). The minimum distance of two peaks. If the distance of two
maximum extreme value less than \code{minpeakdistance}, only the real maximum
value will be left.}

\item{ypeak_min}{\code{y_peak >= ypeak_min}}

\item{r_max}{Similar as \code{r_min}, The maximum threshold should
be greater than \code{r_max}.}

\item{r_min}{Threshold is defined as the difference of peak value with
trough value. There are two threshold (left and right). The minimum threshold
should be greater than r_min.}

\item{rtrough_max}{\code{ytrough <= rtrough_max*A}, A is the amplitude of y.}

\item{MaxPeaksPerYear}{This parameter is used to adjust lambda in iterations.
If PeaksPerYear > MaxPeaksPerYear, then lambda = lambda*2.}

\item{MaxTroughsPerYear}{This parameter is used to adjust lambda in iterations.
If TroughsPerYear > MaxTroughsPerYear, then lambda = lambda*2.}

\item{calendarYear}{If true, only one static calendar growing season will be
returned.}

\item{adj.param}{,
.}

\item{rm.closed}{boolean. Whether check the two closest peaks (or troughs).}

\item{is.continuous}{boolean. Whether the input is continuous? This parameter
is for fluxsite site-year data.}

\item{.check_season}{not used (only for debug)}

\item{verbose}{whether to print \code{options_season} into console?}

\item{...}{ignored.}

\item{d_fit}{A data.frame with the columns of \code{t}, \code{y}, \code{witer...} and \code{ziter...}.}
}
\value{
\itemize{
\item \code{fit}: A data.table of Rough fitting result, with the columns of
(\code{t}, \code{y}, \code{witer1}, ..., \code{witerN}, \code{ziter1}, ..., \code{ziterN}).
\item \code{dt}: A data.table of growing season division information, with the columns
of (\code{beg}, \code{peak}, \code{end}, \code{y_beg}, \code{y_peak}, \code{y_end}, \code{len}, \code{year},
\code{season}, \code{flag}).
}
}
\description{
Divide growing seasons according to rough fitting (\code{rFUN}) result .

For \code{season}, rough fitting is applied for whole.
For \code{season_mov} rough fitting is applied in every year, during which
\code{maxExtendMonth} is extended.
}
\details{
Before growing season division, \code{INPUT} should be added a year in head
and tail first by \code{add_HeadTail}.

Finally, use \code{\link[=findpeaks]{findpeaks()}} to get local maximum and local minimum values.
Two local minimum define a growing season.
If two local minimum(maximum) are too closed, then only the smaller(biger)
is left.
}
\examples{
data("CA_NS6")
d <- CA_NS6

nptperyear <- 23
INPUT <- check_input(d$t, d$y, d$w,
    QC_flag = d$QC_flag,
    nptperyear = nptperyear, south = FALSE,
    maxgap = nptperyear / 4, alpha = 0.02, wmin = 0.2
)
# plot_input(INPUT)

wFUN <- "wTSM"
# all year as a whole
options = list(rFUN = "smooth_wWHIT", wFUN = wFUN, lambda = 10)
brks <- season(INPUT, lambda = 10)
plot_season(INPUT, brks, d)

brks2 = season_input(INPUT, options)
all.equal(brks2, brks)

c(d_fit, info_peak) \%<-\% roughFit(INPUT)
d_season = find_season.peaks(d_fit, info_peak)

c(t, ypred) \%<-\% d_fit[, .(t, ziter2)]
d_season = find_season.default(ypred, t)
all.equal(brks$dt, d_season)

# opt <- .options$season
# brks$fit - d_fit # function passed test

# curve fitting by year
brks_mov <- season_mov(INPUT,
    options = list(
        rFUN = "smooth_wWHIT", wFUN = wFUN,
        lambda = 10,
        r_min = 0.05, ypeak_min = 0.05,
        verbose = TRUE
    )
)
plot_season(INPUT, brks_mov)

rfit <- brks2rfit(brks_mov)
r <- get_pheno(rfit)
}
\seealso{
\code{\link[=findpeaks]{findpeaks()}}.
}
\keyword{internal}
