% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_pheno.R
\name{optim_pheno}
\alias{optim_pheno}
\title{optim_pheno}
\usage{
optim_pheno(
  prior,
  sFUN,
  y,
  t,
  tout,
  method,
  w,
  nptperyear,
  ylu,
  iters = 2,
  wFUN = wTSM,
  lower = -Inf,
  upper = Inf,
  constrain = TRUE,
  verbose = FALSE,
  ...,
  use.cpp = FALSE
)
}
\arguments{
\item{prior}{A vector of initial values for the parameters for which optimal
values are to be found. \code{prior} is suggested giving a column name.}

\item{sFUN}{The name of fine curve fitting functions, can be one of \verb{ 'FitAG', 'FitDL.Beck', 'FitDL.Elmore', 'FitDL.Gu' and 'FitDL.Klos', 'FitDL.Zhang'}.}

\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{tout}{Corresponding doy of prediction.}

\item{method}{The name of optimization method to solve fine fitting, one of
\verb{'BFGS','CG','Nelder-Mead', 'L-BFGS-B', 'nlm', 'nlminb', 'ucminf'} and
\verb{'spg','Rcgmin','Rvmmin', 'newuoa','bobyqa','nmkb','hjkb'}.}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{nptperyear}{Integer, number of images per year, passed to \code{wFUN}.
Only \code{\link[=wTSM]{wTSM()}} needs \code{nptperyear}. If not specified,
\code{nptperyear} will be calculated based on \code{t}.}

\item{ylu}{\verb{[ymin, ymax]}, which is used to force \code{ypred} in the range of \code{ylu}.}

\item{iters}{How many times curve fitting is implemented.}

\item{wFUN}{weights updating function, can be one of 'wTSM', 'wChen' and
'wBisquare'.}

\item{lower, upper}{
    vectors of lower and upper bounds, replicated to be as long as
    \code{start}.  If unspecified, all parameters are assumed to be
    unconstrained.
  }

\item{constrain}{boolean, whether to use parameter constrain}

\item{verbose}{Whether to display intermediate variables?}

\item{...}{other parameters passed to \code{\link[=I_optim]{I_optim()}} or \code{\link[=I_optimx]{I_optimx()}}.}

\item{use.cpp}{(unstable, not used) boolean, whether to use c++ defined fine
fitting function? If \code{FALSE}, R version will be used.}
}
\value{
A \code{\link[=fFIT]{fFIT()}} object, with the element of:
\itemize{
\item \code{tout}: The time of output curve fitting time-series.
\item \code{zs}  : Smoothed vegetation time-series of every iteration.
\item \code{ws}  : Weights of every iteration.
\item \code{par} : Final optimized parameter of fine fitting.
\item \code{fun} : The name of fine fitting.
}
}
\description{
Interface of optimization functions for double logistics and other parametric
curve fitting functions.
}
\examples{
# library(magrittr)
# library(purrr)

# simulate vegetation time-series
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)

FUN = doubleLog_Beck
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
par0 = c( mn  = 0.15, mx  = 0.65, sos = 100, rsp = 0.12, eos = 200, rau = 0.12)

y <- FUN(par, t)

methods = c("BFGS", "ucminf", "nlm", "nlminb")
opt1 <- I_optim(par0, doubleLog_Beck, y, t, methods) # "BFGS", "ucminf", "nlm",
# opt2 <- I_optimx(prior, fFUN, y, t, tout, )

sFUN   = "doubleLog.Beck" # doubleLog.Beck
r <- optim_pheno(par0, sFUN, y, t, tout, method = methods[4],
                 nptperyear = 46, iters = 2, wFUN = wTSM, verbose = FALSE, use.julia = FALSE)
}
\seealso{
\code{\link[=fFIT]{fFIT()}}, \code{\link[stats:nlminb]{stats::nlminb()}}
}
