% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubleLogistics-init_param.R
\name{init_param}
\alias{init_param}
\alias{init_Zhang}
\alias{init_AG}
\alias{init_AG2}
\alias{init_Beck}
\alias{init_Elmore}
\alias{init_Gu}
\alias{init_Klos}
\title{init_param}
\usage{
init_param(y, t, w, type = 1L)

init_Zhang(e, type = 1L, ...)

init_AG(e, type = 1L, ...)

init_AG2(e, type = 1L, ...)

init_Beck(e, type = 1L, ...)

init_Elmore(e, type = 1L, ...)

init_Gu(e, type = 1L, ...)

init_Klos(e, type = 1L, ...)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{type}{integer, \code{1} or \code{-1}
\itemize{
\item \code{1}: trough-to-trough curve fitting
\item \code{-1}: peak-to-peak curve fitting
}}

\item{e}{The object returned by \code{\link[=init_param]{init_param()}}}

\item{...}{Others will be ignored.}
}
\description{
Initialize parameters of double logistic function
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c(
    mn  = 0.1,
    mx  = 0.7,
    sos = 50,
    rsp = 0.1,
    eos = 250,
    rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

l_param <- init_param(y, t)
}
\keyword{internal}
