% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GOF.R
\name{get_GOF}
\alias{get_GOF}
\alias{get_GOF.list}
\alias{get_GOF.fFITs}
\alias{get_GOF.fFIT}
\title{get_GOF}
\usage{
get_GOF(x, ...)

\method{get_GOF}{list}(x, ...)

\method{get_GOF}{fFITs}(x, ...)

\method{get_GOF}{fFIT}(x, data, ...)
}
\arguments{
\item{x}{\code{fFITs} object returned by \code{\link[=curvefit]{curvefit()}}, or list of \code{fFITs} objects}

\item{...}{ignored.}

\item{data}{A data.frame with the columns of \code{c('t', 'y')}}
}
\value{
\itemize{
\item \code{meth}: The name of fine curve fitting method
\item \code{RMSE}: Root Mean Square Error
\item \code{NSE} : Nash-Sutcliffe model efficiency coefficient
\item \code{R}   : Pearson-Correlation
\item \code{R2}  : determined coefficient
\item \code{pvalue}: pvalue of \code{R}
\item \code{n}   : The number of observations
}
}
\description{
Goodness-of-fitting (GOF) of fine curve fitting results.
}
\examples{
library(phenofit)
# simulate vegetation time-series
FUN = doubleLog.Beck
par  = c( mn  = 0.1, mx  = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- FUN(par, t)
methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fit <- curvefit(y, t, tout, methods) # `fFITs` (fine-fitting) object 
fits <- list(`2001` = fit, `2002` = fit) # multiple years

l_param   <- get_param(fits)
d_GOF     <- get_GOF(fits)
d_fitting <- get_fitting(fits)
l_pheno   <- get_pheno(fits, "AG", IsPlot=TRUE)
}
\references{
\enumerate{
\item https://en.wikipedia.org/wiki/Nash-Sutcliffe_model_efficiency_coefficient \cr
\item https://en.wikipedia.org/wiki/Pearson_correlation_coefficient
}
}
\seealso{
\code{\link[=curvefit]{curvefit()}}
}
