% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_onco_pcwg3.R
\docType{data}
\name{rs_onco_pcwg3}
\alias{rs_onco_pcwg3}
\title{Disease Response (PCWG3) for Oncology}
\format{
A data frame with 14 columns:
\describe{
\item{STUDYID}{Study Identifier}
\item{DOMAIN}{Domain Abbreviation}
\item{USUBJID}{Unique Subject Identifier}
\item{RSSEQ}{Sequence Number}
\item{RSTESTCD}{Response Assessment Short Name}
\item{RSTEST}{Response Assessment Name}
\item{RSCAT}{Category for Response Assessment}
\item{RSORRES}{Response Assessment Original Result}
\item{RSSTRESC}{Response Assessment Result in Std Format}
\item{RSEVAL}{Evaluator}
\item{VISITNUM}{Visit Number}
\item{VISIT}{Visit Name}
\item{RSDTC}{Date/Time of Response Assessment}
\item{RSDY}{Study Day of Response Assessment}
}
}
\source{
Generated dataset
}
\usage{
rs_onco_pcwg3
}
\description{
A SDTM RS dataset for oncology studies using PCWG3 criteria intended for examples of ADaM dataset creation
}
\details{
Disease Response (PCWG3) for Oncology

A SDTM RS dataset for oncology studies using PCWG3 criteria intended for examples of ADaM dataset creation

Contains a set of 4 unique Test Short Names and Test Names: \tabular{ll}{
\strong{RSTESTCD} \tab \strong{RSTEST} \cr
BONERESP \tab Bone Response        \cr
OVRLRESP \tab Overall Response     \cr
SFTSRESP \tab Soft Tissue Response \cr
TMRESP   \tab Tumor Marker Response
}
}
\author{
Tomoyuki Namai
}
\keyword{dataset}
