% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp.R
\docType{data}
\name{pp}
\alias{pp}
\title{Pharmacokinetic Parameters}
\format{
A data frame with 14 columns:
\describe{
\item{STUDYID}{Study Identifier}
\item{DOMAIN}{Domain Abbreviation}
\item{USUBJID}{Unique Subject Identifier}
\item{PPSEQ}{Sequence Number}
\item{PPTESTCD}{Parameter Short Name}
\item{PPTEST}{Parameter Name}
\item{PPCAT}{Parameter Category}
\item{PPORRES}{Result or Finding in Original Units}
\item{PPORRESU}{Original Units}
\item{PPSTRESC}{Character Result/Finding in Std Format}
\item{PPSTRESN}{Numeric Result/Finding in Standard Units}
\item{PPSTRESU}{Standard Units}
\item{PPSPEC}{Specimen Material Type}
\item{PPRFDTC}{Date/Time of Reference Point}
}
}
\source{
\href{https://github.com/pharmaverse/pharmaversesdtm/blob/main/data/pp.rda}{Access the source of the Pharmacokinetic Parameters dataset.}
}
\usage{
pp
}
\description{
A SDTM PP dataset simulated by Antonio Rodriguez Contesti
}
\details{
Pharmacokinetic Parameters

A SDTM PP dataset simulated by Antonio Rodriguez Contesti

Contains a set of 10 unique Test Short Names and Test Names: \tabular{ll}{
\strong{PPTESTCD} \tab \strong{PPTEST} \cr
AUCALL  \tab AUC All                      \cr
AUCLST  \tab AUC to Last Nonzero Conc     \cr
CLST    \tab Last Nonzero Conc            \cr
CMAX    \tab Max Conc                     \cr
LAMZ    \tab Lambda z                     \cr
LAMZHL  \tab Half-Life Lambda z           \cr
LAMZNPT \tab Number of Points for Lambda z\cr
RCAMINT \tab Ae                           \cr
RENALCL \tab CLR                          \cr
TMAX    \tab Time of CMAX
}
}
\author{
Antonio Rodriguez Contesti
}
\keyword{dataset}
