% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{.consolidate_ambiguous_attrs}
\alias{.consolidate_ambiguous_attrs}
\title{Consolidate Ambiguous Match Attributes}
\usage{
.consolidate_ambiguous_attrs(output_f, pipe_1_5, infra_out)
}
\arguments{
\item{output_f}{Final output tibble from the matching pipeline}

\item{pipe_1_5}{List containing results from nodes 1-5 (genus/species matching)}

\item{infra_out}{List containing results from nodes 6-7 (infraspecies matching)}
}
\value{
output_f with attached ambiguous match attributes:
  - attr(*, "ambiguous_genera")
  - attr(*, "ambiguous_species")
  - attr(*, "ambiguous_infraspecies")
}
\description{
Collects ambiguous match attributes from intermediate pipeline results
and attaches them to the final output. This ensures that ambiguous match
information created during fuzzy matching is preserved through all
transformations and available to the user via get_ambiguous_matches().
}
\details{
This function solves the problem of attributes being lost during dplyr
transformations (left_join, mutate, bind_rows, etc.). It retrieves
attributes created in earlier stages of the pipeline and re-attaches
them to the final output.
}
\keyword{internal}
