% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{validate_weibull_parameters}
\alias{validate_weibull_parameters}
\title{Validate Weibull Parameters}
\usage{
validate_weibull_parameters(
  given_first_quartile,
  given_median,
  threshold,
  asymptote
)
}
\arguments{
\item{given_first_quartile}{The first quartile of the data.}

\item{given_median}{The median of the data.}

\item{threshold}{A constant threshold value.}

\item{asymptote}{A constant asymptote value (gamma).}
}
\value{
Logical value indicating whether the parameters are valid (TRUE) or not (FALSE)
}
\description{
This function validates the given parameters for calculating Weibull distribution.
}
\examples{
# Validate parameters
is_valid <- validate_weibull_parameters(
  given_first_quartile = 30,
  given_median = 50,
  threshold = 15,
  asymptote = 0.8
)
print(is_valid)
}
