% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjugate_plot.R
\name{plot.conjugate}
\alias{plot.conjugate}
\title{Plot a \code{conjugate} object.}
\usage{
\method{plot}{conjugate}(x, ...)
}
\arguments{
\item{x}{An object of class \code{conjugate}.}

\item{...}{further arguments, ignored.}
}
\description{
Plot a \code{conjugate} object.
}
\examples{
x <- conjugate(
  s1 = rnorm(10, 50, 10), s2 = rnorm(10, 60, 12), method = "t",
  priors = list(list(mu = 40, sd = 10), list(mu = 45, sd = 8)),
  rope_range = c(-5, 8), rope_ci = 0.89,
  cred.int.level = 0.89, hypothesis = "equal"
)
plot(x)

}
