% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_session_analytics_data}
\alias{lexmodelsv2_list_session_analytics_data}
\title{Retrieves a list of metadata for individual user sessions with your bot}
\usage{
lexmodelsv2_list_session_analytics_data(
  botId,
  startDateTime,
  endDateTime,
  sortBy = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{botId}{[required] The identifier for the bot for which you want to retrieve session
analytics.}

\item{startDateTime}{[required] The date and time that marks the beginning of the range of time for
which you want to see session analytics.}

\item{endDateTime}{[required] The date and time that marks the end of the range of time for which you
want to see session analytics.}

\item{sortBy}{An object specifying the measure and method by which to sort the session
analytics data.}

\item{filters}{A list of objects, each of which describes a condition by which you want
to filter the results.}

\item{maxResults}{The maximum number of results to return in each page of results. If
there are fewer results than the maximum page size, only the actual
number of results are returned.}

\item{nextToken}{If the response from the ListSessionAnalyticsData operation contains
more results than specified in the maxResults parameter, a token is
returned in the response.

Use the returned token in the nextToken parameter of a
ListSessionAnalyticsData request to return the next page of results. For
a complete set of results, call the ListSessionAnalyticsData operation
until the nextToken returned in the response is null.}
}
\description{
Retrieves a list of metadata for individual user sessions with your bot. The \code{startDateTime} and \code{endDateTime} fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_session_analytics_data/} for full documentation.
}
\keyword{internal}
