% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_in_one_functions.R
\name{import_and_clean_viewr}
\alias{import_and_clean_viewr}
\title{Import + clean_viewr()}
\usage{
import_and_clean_viewr(
  file_name,
  file_id = NA,
  relabel_viewr_axes = TRUE,
  gather_tunnel_data = TRUE,
  trim_tunnel_outliers = TRUE,
  standardization_option = "rotate_tunnel",
  get_velocity = TRUE,
  select_x_percent = TRUE,
  rename_viewr_characters = FALSE,
  separate_trajectories = TRUE,
  get_full_trajectories = TRUE,
  fill_traj_gaps = FALSE,
  ...
)
}
\arguments{
\item{file_name}{Target file}

\item{file_id}{Optional}

\item{relabel_viewr_axes}{default TRUE, should axes be relabeled?}

\item{gather_tunnel_data}{default TRUE, should tunnel data be gathered?}

\item{trim_tunnel_outliers}{default TRUE, outliers be trimmed?}

\item{standardization_option}{default "rotate_tunnel"; which standardization
option should be used? See Details for more.}

\item{get_velocity}{default TRUE, should velocity be computed?}

\item{select_x_percent}{default TRUE, should a region of interest be
selected?}

\item{rename_viewr_characters}{default FALSE, should subjects be renamed?}

\item{separate_trajectories}{default TRUE, should trajectories be defined?}

\item{get_full_trajectories}{default TRUE, should only full trajectories be
retained?}

\item{fill_traj_gaps}{default FALSE, should gaps in trajectories be filled?}

\item{...}{Additional arguments passed to the corresponding functions.}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) that has passed
through several \code{pathviewr} functions as desired by the user,
resulting in data that have been cleaned and ready for analyses.
}
\description{
Import a file and then, akin to \code{clean_viewr}, run through as many
cleaning steps as desired.
}
\details{
Each argument corresponds to a standalone function in
\code{pathviewr}. E.g. the parameter \code{relabel_viewr_axes} allows a
user to choose whether \code{pathviewr::relabel_viewr_axes()} is run
internally. Should the user desire to use any non-default parameter values
for any functions included here, they should be supplied to this function
as additional arguments formatted exactly as they would appear in their
corresponding function(s). E.g. if the "autodetect" feature in
\code{pathviewr::separate_trajectories()} is desired, add an argument
\code{max_frame_gap = "autodetect"} to the arguments supplied to this
function.
}
\examples{
library(pathviewr)

## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

motive_full <-
  motive_data \%>\%
  clean_viewr(desired_percent = 50,
              max_frame_gap = "autodetect",
              span = 0.95)

## Alternatively, used the import_and_clean_viewr()
## function to combine these steps
motive_import_and_clean <-
  import_and_clean_viewr(
    file_name = system.file("extdata", "pathviewr_motive_example_data.csv",
                            package = 'pathviewr'),
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )
}
\seealso{
Other all in one functions: 
\code{\link{clean_viewr}()}
}
\author{
Vikram B. Baliga
}
\concept{all in one functions}
