% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anamorph.R
\name{anamorph}
\alias{anamorph}
\title{Anamorph}
\usage{
anamorph(x, k, plot = FALSE)
}
\arguments{
\item{x}{vector of data to transform}

\item{k}{number of Hermite polynomials to use}

\item{plot}{logical; plot the transformation?}
}
\value{
Returns two function in a list
\item{xtog }{Function to transform arbitrary variable x into a
Gaussian distribution}
\item{gtox }{The back transformation}
}
\description{
Creates functions that transform arbitrary distributions into
Gaussian distributions, and vice versa.
}
\details{
Increasing k can give a better fit.
}
\examples{
set.seed(42)
x <- c(rnorm(50, 0, 1), rnorm(50, 6, 1))
hist(x)
ana.fun <- anamorph(x, 30, plot = TRUE)
xg <- ana.fun$xtog(x)
qqnorm(xg)
qqline(xg)
all.equal(x, ana.fun$gtox(xg))
}
\references{
Wackernagel, H. (2003) \emph{Multivariate Geostatistics.} 3rd edition, Springer-Verlag, Berlin. \doi{10.1007/978-3-662-05294-5}
}
\author{
Richard Telford \email{Richard.Telford@bio.uib.no}
}
\keyword{manip}
