% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{paddle_create_transaction}
\alias{paddle_create_transaction}
\title{Create a Transaction}
\usage{
paddle_create_transaction(
  items,
  status = NULL,
  customer_id = NULL,
  address_id = NULL,
  business_id = NULL,
  custom_data = NULL,
  currency_code = NULL,
  collection_mode = NULL,
  discount_id = NULL,
  billing_details = NULL,
  billing_period = NULL,
  checkout = NULL,
  include = NULL
)
}
\arguments{
\item{items}{List of item objects. Each must contain `price_id` (Character, required) and `quantity` (integer, required).}

\item{status}{Character. Optional. Must be `"billed"` or skipped to let Paddle set the status.}

\item{customer_id}{Character. Optional. Paddle customer ID (e.g., "ctm_123").}

\item{address_id}{Character. Optional. Paddle address ID (e.g., "add_456"). Requires `customer_id`.}

\item{business_id}{Character. Optional. Paddle business ID. Requires `customer_id`.}

\item{custom_data}{Named list. Optional structured metadata.}

\item{currency_code}{Character. Optional. Must be `"USD"`, `"EUR"`, or `"GBP"` if `collection_mode = "manual"`.}

\item{collection_mode}{Character. Optional. Must be one of `"automatic"` or `"manual"`. Defaults to `"automatic"`.}

\item{discount_id}{Character. Optional. Paddle discount ID.}

\item{billing_details}{List. Required if `collection_mode = "manual"`. May include:
- `payment_terms` → list with `interval` (Character, must be one of `"day"`, `"week"`, `"month"`, `"year"`) and `frequency` (integer)
- `enable_checkout` (logical)
- `purchase_order_number` (Character)
- `additional_information` (Character or null)}

\item{billing_period}{List with `starts_at` and `ends_at` in RFC 3339 format. Optional.}

\item{checkout}{List with `url` (Character) to override payment link. Optional.}

\item{include}{Character vector. Must be one of `"address"`, `"adjustments"`, `"adjustments_totals"`, `"available_payment_methods"`, `"business"`, `"customer"`, `"discount"`. Optional.}
}
\value{
A list containing the created transaction and metadata.
}
\description{
Creates a new transaction in the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_create_transaction(
 items = list(
 list(price_id = "pri_123", quantity = 1)
 )
)
\dontshow{\}) # examplesIf}
}
