% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.r
\name{pac.resid}
\alias{pac.resid}
\title{Pac-Man Residual Function}
\usage{
pac.resid(
  x,
  y,
  title,
  taxis,
  model = lm(y ~ x, data = data.frame(x, y)),
  color1 = "gold",
  standardize = FALSE
)
}
\arguments{
\item{x, y}{Numeric data}

\item{title}{Figure title}

\item{taxis}{Vector with the first entry being the axis label and the second entry being units}

\item{model}{An object for which the extraction of model residuals is meaningful.}

\item{color1}{Color value as string or rgb}

\item{standardize}{Boolean to standardize the residual value}
}
\value{
Pac-Man residual plot
}
\description{
A visualization technique in R for regression analysis results, specifically residual values, based on a restricted
radial coordinate system. It provides a broad view perspective on the performance of regression models, and supports
most model inputs.
}
\examples{
data("cars")
x <- cars$dist
y <- cars$speed
pac.resid(x,y, 'Example 2',
            c("Temperature",'degC'),
            color1="lightblue",
            standardize=TRUE)
}
\keyword{regression}
\keyword{visualization}
