% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optweight.svy.fit.R
\name{optweight.svy.fit}
\alias{optweight.svy.fit}
\title{Fitting Function for Optweight for Survey Weights}
\usage{
optweight.svy.fit(
  covs,
  targets,
  tols = 0,
  s.weights = NULL,
  b.weights = NULL,
  norm = "l2",
  std.binary = FALSE,
  std.cont = TRUE,
  min.w = 1e-08,
  verbose = FALSE,
  solver = NULL,
  ...
)
}
\arguments{
\item{covs}{a numeric matrix of covariates to be targeted.}

\item{targets}{a vector of target population mean values for each covariate.
The resulting weights will yield sample means within \code{tols} units of
the target values for each covariate. If any target values are \code{NA},
the corresponding variable will not be targeted and its weighted mean will
be wherever the weights yield the smallest variance. To ensure the weighted
mean for a covariate is equal to its unweighted mean (i.e., so that its
original mean is its target mean), its original mean must be supplied as a
target.}

\item{tols}{a vector of target balance tolerance values. Default is 0.}

\item{s.weights}{an optional vector of sampling weights. Default is a vector of 1s.}

\item{b.weights}{an optional vector of base weights. Default is a vector of 1s.}

\item{norm}{\code{character}; a string containing the name of the norm corresponding to the objective function to minimize. Allowable options include \code{"l1"} for the L1 norm, \code{"l2"} for the L2 norm (the default), \code{"linf"} for the L\eqn{\infty} norm, \code{"entropy"} for the negative entropy, and \code{"log"} for the sum of the negative logs. See Details at \code{\link[=optweight.fit]{optweight.fit()}} for more information.}

\item{std.binary, std.cont}{\code{logical}; whether the tolerances are in standardized mean units (\code{TRUE}) or raw units (\code{FALSE}) for binary variables and continuous variables, respectively. The default is \code{FALSE} for \code{std.binary} because raw proportion differences make more sense than standardized mean difference for binary variables. These arguments are analogous to the \code{binary} and \code{continuous} arguments in \code{bal.tab()} in \pkg{cobalt}.}

\item{min.w}{\code{numeric}; a single value less than 1 for the smallest allowable weight. Some analyses require nonzero weights for all units, so a small, nonzero minimum may be desirable. The default is \code{1e-8} (\eqn{10^{-8}}), which does not materially change the properties of the weights from a minimum of 0 but prevents warnings in some packages that use weights to estimate treatment effects. When \code{norm} is \code{"entropy"} or \code{"log"} and \code{min.w <= 0}, \code{min.w} will be set to the smallest nonzero value.}

\item{verbose}{\code{logical}; whether information on the optimization problem solution should be printed. Default is \code{FALSE}.}

\item{solver}{string; the name of the optimization solver to use. Allowable options depend on \code{norm}. Default is to use whichever eligible solver is installed, if any, or the default solver for the corresponding \code{norm}. See Details at \code{\link[=optweight.fit]{optweight.fit()}} for information.}

\item{...}{Options that are passed to the settings function corresponding to \code{solver}.}
}
\value{
An \code{optweight.svy.fit} object with the following elements:
\item{w}{The estimated weights, one for each unit.}
\item{duals}{A data.frame containing the dual variables for each covariate. See Zubizarreta
(2015) for interpretation of these values.}
\item{info}{A list containing information about the performance of the optimization at termination.}
}
\description{
\code{optweight.svy.fit()} performs the optimization for \code{\link[=optweight.svy]{optweight.svy()}} and should, in most cases, not be
used directly. Little processing of inputs is performed, so they must be given
exactly as described below.
}
\details{
\code{optweight.svy.fit()} transforms the inputs into the required inputs for the optimization functions, which are (sparse) matrices and vectors, and then supplies the outputs (the weights, dual variables, and convergence information) back to \code{\link[=optweight.svy]{optweight.svy()}}. Little processing of inputs is performed, as this is normally handled by \code{optweight.svy()}.

Target constraints are applied to the product of the estimated weights and the sampling weights. In addition, sum of the product of the estimated weights and the sampling weights is constrained to be equal to the sum of the product of the base weights and sampling weights.
}
\examples{
\dontshow{if (requireNamespace("cobalt", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("cobalt")
data("lalonde", package = "cobalt")

covs <- splitfactor(lalonde[c("age", "educ", "race",
                              "married", "nodegree")],
                    drop.first = FALSE)

targets <- c(23, 9, .3, .3, .4, .2, .5)

ows.fit <- optweight.svy.fit(covs,
                             targets = targets,
                             norm = "l2")

#Unweighted means
col_w_mean(covs)

#Weighted means; same as targets
col_w_mean(covs, w = ows.fit$w)
\dontshow{\}) # examplesIf}
}
\references{
Zubizarreta, J. R. (2015). Stable Weights that Balance Covariates for Estimation With Incomplete Outcome Data. \emph{Journal of the American Statistical Association}, 110(511), 910–922. \doi{10.1080/01621459.2015.1023805}
}
\seealso{
\code{\link[=optweight.svy]{optweight.svy()}} which you should use for estimating the
balancing weights, unless you know better.

\code{\link[=optweight.fit]{optweight.fit()}} for more details about the allowed norms and optimization.
}
